* International Extension - What Caused the U.S Pandemic-Era Inflation? Bernanke, Blanchard 2023 
* This version : April 16, 2024
* Please contact Dilek Sevinc (dsevinc@piie.com) for further questions. 

* Wage regression for the 10 economies (excl. Japan due to confidentiality issues) 
* USA, ECB, BOE, (JPN), FRA, GER, ESP, ITA, NLD, BEL, CAN

global basePath1 ".../Replication Package/(1) Data"
global basePath2 ".../Replication Package/(3) Regression Results"

****************************************************************************************
* wage, precovid sample 
****************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"


*** USA ECB BOE FRA ESP NLD CAN // ITA and BEL use a different approach // GER uses different specification; there is an additional do file, however, I keep GER in this file with the original specification as well. The data reported in the paper are from the alternative specification. 
** here grouped together because this is the precovid sample. Full sample will be different as some use dummies and others don't and instead adjust the wage series.  

local teams "USA ECB BOE FRA GER ESP NLD CAN" 
local startperiod_USA 1989:1
local startperiod_ECB 1999:1
local startperiod_BOE 1990:1
local startperiod_FRA 1989:1
local startperiod_GER 1996:1
local startperiod_ESP 1995:1
local startperiod_BEL 1996:1
local startperiod_NLD 1989:1
local startperiod_CAN 1993:1


foreach c of local teams{

constraint define 1  l1.gw_`c' + l2.gw_`c' + l3.gw_`c' + l4.gw_`c' + l1.cf1_`c' + l2.cf1_`c' + l3.cf1_`c' + l4.cf1_`c' = 1

cnsreg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' l1.magpty_`c' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' if inrange(period, tq(`startperiod_`c''),tq(2019:4)), c(1)

eststo col1
predict gwf1_`c'_precovid if inrange(period, tq(`startperiod_`c''),tq(2019:4))
gen gw_`c'_residuals_precovid = gw_`c'-gwf1_`c'_precovid


* Save coefficients in excel format 
putexcel set "(1) wage_eq_coeff", modify sheet("gw_`c'")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(1) wage_summary_stats", modify sheet("gw_`c'")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.gw through l4.gw"
putexcel A3 = "l1.cf1 through l4.cf1"
putexcel A4 = "l1.vu through l4.vu"
putexcel A5 = "l1.diffcpicf through l4.diffcpicf"
putexcel A6 = "magpty"
putexcel A7 = "dummy 2020Q2"
putexcel A8 = "dummy 2020Q3"
putexcel A10 = "R2"
putexcel A11 = "number of observations"
putexcel A13 = "homogeneity constraint"

* Compute sum of coefficients 
gen aa1_`c' = _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c']  
gen bb1_`c' = _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c']
gen cc1_`c' = _b[l1.vu_`c'] + _b[l2.vu_`c'] + _b[l3.vu_`c'] + _b[l4.vu_`c']  
gen dd1_`c' = _b[l1.diffcpicf_`c'] + _b[l2.diffcpicf_`c'] + _b[l3.diffcpicf_`c'] + _b[l4.diffcpicf_`c']

putexcel B2 = aa1_`c'
putexcel B3 = bb1_`c'
putexcel B4 = cc1_`c'
putexcel B5 = dd1_`c'
putexcel B6 = _b[l1.magpty_`c']
putexcel B7 = "."
putexcel B8 = "."


* P-value (sum)
test _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c']  = 0
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7)                                          

test _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] = 0
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7)

test _b[l1.vu_`c'] + _b[l2.vu_`c'] + _b[l3.vu_`c'] + _b[l4.vu_`c'] = 0
matrix b = r(p)'
putexcel C4 = matrix(b), nformat(number_d7)  

test _b[l1.diffcpicf_`c'] + _b[l2.diffcpicf_`c'] + _b[l3.diffcpicf_`c'] + _b[l4.diffcpicf_`c'] = 0
matrix b = r(p)'
putexcel C5 = matrix(b), nformat(number_d7) 

 				   					   
* P-value(joint)
test l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' 
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7)  
   
test l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c'
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7) 
   
test l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c'
matrix b = r(p)'
putexcel D4 = matrix(b), nformat(number_d7)    

test l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c'
matrix b = r(p)'
putexcel D5 = matrix(b), nformat(number_d7)    

test l1.magpty_`c'
matrix b = r(p)'
putexcel D6 = matrix(b), nformat(number_d7)


* R-square and number of observations
corr gw_`c' gwf1_`c' if period>=tq(1990:1)
gen r2aa_`c' = r(rho)^2
putexcel B10 = r2aa_`c'

gen n_obsaa_`c' = e(N)
putexcel B11 = n_obsaa_`c'


*** unconstrained with homogeneity test 
reg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' l1.magpty_`c' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' if inrange(period, tq(`startperiod_`c''),tq(2019:4))

test _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c'] + _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] = 1
matrix b = r(p)'
putexcel B13 = matrix(b), nformat(number_d7)  

	}


********ITA uses a slightly different specification 
constraint define 1  l1.gw_ITA + l2.gw_ITA + l3.gw_ITA + l4.gw_ITA + l1.cf1_ITA + l2.cf1_ITA + l3.cf1_ITA + l4.cf1_ITA = 1

cnsreg gw_ITA l1.gw_ITA l2.gw_ITA l3.gw_ITA l4.gw_ITA l1.cf1_ITA l2.cf1_ITA l3.cf1_ITA l4.cf1_ITA magpty_ITA l1.vu_ITA l2.vu_ITA l3.vu_ITA l4.vu_ITA l1.diffcpicf_ITA l2.diffcpicf_ITA l3.diffcpicf_ITA l4.diffcpicf_ITA if inrange(period, tq(1999:1),tq(2019:4)), c(1)

eststo col1
predict gwf1_ITA_precovid if inrange(period, tq(1999:1),tq(2019:4))
gen gw_ITA_residuals_precovid = gw_ITA-gwf1_ITA_precovid


* Save coefficients in excel format 
putexcel set "(1) wage_eq_coeff", modify sheet("gw_ITA")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(1) wage_summary_stats", modify sheet("gw_ITA")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.gw through l4.gw"
putexcel A3 = "l1.cf1 through l4.cf1"
putexcel A4 = "l1.vu through l4.vu"
putexcel A5 = "l1.diffcpicf through l4.diffcpicf"
putexcel A6 = "magpty"
putexcel A7 = "dummy 2020Q2"
putexcel A8 = "dummy 2020Q3"
putexcel A10 = "R2"
putexcel A11 = "number of observations"
putexcel A13 = "homogeneity constraint"

* Compute sum of coefficients 
gen aa1_ITA = _b[l1.gw_ITA] + _b[l2.gw_ITA] + _b[l3.gw_ITA] + _b[l4.gw_ITA]  
gen bb1_ITA = _b[l1.cf1_ITA] + _b[l2.cf1_ITA] + _b[l3.cf1_ITA] + _b[l4.cf1_ITA]
gen cc1_ITA = _b[l1.vu_ITA] + _b[l2.vu_ITA] + _b[l3.vu_ITA] + _b[l4.vu_ITA]  
gen dd1_ITA = _b[l1.diffcpicf_ITA] + _b[l2.diffcpicf_ITA] + _b[l3.diffcpicf_ITA] + _b[l4.diffcpicf_ITA]

putexcel B2 = aa1_ITA
putexcel B3 = bb1_ITA
putexcel B4 = cc1_ITA
putexcel B5 = dd1_ITA
putexcel B6 = _b[magpty_ITA]
putexcel B7 = "."
putexcel B8 = "."


* P-value (sum)
test _b[l1.gw_ITA] + _b[l2.gw_ITA] + _b[l3.gw_ITA] + _b[l4.gw_ITA]  = 0
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7)                                          

test _b[l1.cf1_ITA] + _b[l2.cf1_ITA] + _b[l3.cf1_ITA] + _b[l4.cf1_ITA] = 0
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7)

test _b[l1.vu_ITA] + _b[l2.vu_ITA] + _b[l3.vu_ITA] + _b[l4.vu_ITA] = 0
matrix b = r(p)'
putexcel C4 = matrix(b), nformat(number_d7)  

test _b[l1.diffcpicf_ITA] + _b[l2.diffcpicf_ITA] + _b[l3.diffcpicf_ITA] + _b[l4.diffcpicf_ITA] = 0
matrix b = r(p)'
putexcel C5 = matrix(b), nformat(number_d7) 

 				   					   
* P-value(joint)
test l1.gw_ITA l2.gw_ITA l3.gw_ITA l4.gw_ITA 
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7)  
   
test l1.cf1_ITA l2.cf1_ITA l3.cf1_ITA l4.cf1_ITA
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7) 
   
test l1.vu_ITA l2.vu_ITA l3.vu_ITA l4.vu_ITA
matrix b = r(p)'
putexcel D4 = matrix(b), nformat(number_d7)    

test l1.diffcpicf_ITA l2.diffcpicf_ITA l3.diffcpicf_ITA l4.diffcpicf_ITA
matrix b = r(p)'
putexcel D5 = matrix(b), nformat(number_d7)    

test magpty_ITA
matrix b = r(p)'
putexcel D6 = matrix(b), nformat(number_d7)


* R-square and number of observations
corr gw_ITA gwf1_ITA if period>=tq(1990:1)
gen r2aa_ITA = r(rho)^2
putexcel B10 = r2aa_ITA

gen n_obsaa_ITA = e(N)
putexcel B11 = n_obsaa_ITA


*** unconstrained with homogeneity test 
reg gw_ITA l1.gw_ITA l2.gw_ITA l3.gw_ITA l4.gw_ITA l1.cf1_ITA l2.cf1_ITA l3.cf1_ITA l4.cf1_ITA magpty_ITA l1.vu_ITA l2.vu_ITA l3.vu_ITA l4.vu_ITA l1.diffcpicf_ITA l2.diffcpicf_ITA l3.diffcpicf_ITA l4.diffcpicf_ITA if inrange(period, tq(1999:1),tq(2019:4))

test _b[l1.gw_ITA] + _b[l2.gw_ITA] + _b[l3.gw_ITA] + _b[l4.gw_ITA] + _b[l1.cf1_ITA] + _b[l2.cf1_ITA] + _b[l3.cf1_ITA] + _b[l4.cf1_ITA] = 1
matrix b = r(p)'
putexcel B13 = matrix(b), nformat(number_d7)  




********BEL uses social programs variable ssci 
constraint define 1 l1.gw_BEL + l2.gw_BEL + l3.gw_BEL + l4.gw_BEL + l1.cf1_BEL + l2.cf1_BEL + l3.cf1_BEL + l4.cf1_BEL = 1

cnsreg gw_BEL l1.gw_BEL l2.gw_BEL l3.gw_BEL l4.gw_BEL l1.cf1_BEL l2.cf1_BEL l3.cf1_BEL l4.cf1_BEL l1.magpty_BEL l1.vu_BEL l2.vu_BEL l3.vu_BEL l4.vu_BEL l1.diffcpicf_BEL l2.diffcpicf_BEL l3.diffcpicf_BEL l4.diffcpicf_BEL ussc1_BEL c.dQ1_BEL#cL.diffcpicf_BEL if inrange(period, tq(1996:1),tq(2019:4)), c(1)

eststo col1
predict gwf1_social_BEL if inrange(period, tq(1996:1),tq(2019:4))
gen gw_social_residuals_BEL = gw_BEL-gwf1_social_BEL


* Save coefficients in excel format 
putexcel set "(1) wage_eq_coeff", modify sheet("gw_social_BEL")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format
putexcel set "(1) wage_summary_stats", modify sheet("gw_social_BEL")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.gw_social through l4.gw_social"
putexcel A3 = "l1.cf1 through l4.cf1"
putexcel A4 = "l1.vu through l4.vu"
putexcel A5 = "l1.diffcpicf through l4.diffcpicf"
putexcel A6 = "magpty"
putexcel A7 = "social programs"
putexcel A9 = "R2"
putexcel A10 = "number of observations"
putexcel A12 = "homogeneity constraint"

* Compute sum of coefficients 
gen aa1_social_BEL = _b[l1.gw_BEL] + _b[l2.gw_BEL] + _b[l3.gw_BEL] + _b[l4.gw_BEL]  
gen bb1_social_BEL = _b[l1.cf1_BEL] + _b[l2.cf1_BEL] + _b[l3.cf1_BEL] + _b[l4.cf1_BEL]
gen cc1_social_BEL = _b[l1.vu_BEL] + _b[l2.vu_BEL] + _b[l3.vu_BEL] + _b[l4.vu_BEL]  
gen dd1_social_BEL = _b[l1.diffcpicf_BEL] + _b[l2.diffcpicf_BEL] + _b[l3.diffcpicf_BEL] + _b[l4.diffcpicf_BEL]

putexcel B2 = aa1_social_BEL
putexcel B3 = bb1_social_BEL
putexcel B4 = cc1_social_BEL
putexcel B5 = dd1_social_BEL

putexcel B6 = _b[l1.magpty_BEL]
putexcel B7 = _b[ussc1_BEL]


* P-value (sum)
test _b[l1.gw_BEL] + _b[l2.gw_BEL] + _b[l3.gw_BEL] + _b[l4.gw_BEL] = 0
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7)                                          

test _b[l1.cf1_BEL] + _b[l2.cf1_BEL] + _b[l3.cf1_BEL] + _b[l4.cf1_BEL] = 0
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7)

test _b[l1.vu_BEL] + _b[l2.vu_BEL] + _b[l3.vu_BEL] + _b[l4.vu_BEL] = 0
matrix b = r(p)'
putexcel C4 = matrix(b), nformat(number_d7)  

test _b[l1.diffcpicf_BEL] + _b[l2.diffcpicf_BEL] + _b[l3.diffcpicf_BEL] + _b[l4.diffcpicf_BEL] = 0
matrix b = r(p)'
putexcel C5 = matrix(b), nformat(number_d7) 

	   					   
* P-value (joint)
test l1.gw_BEL l2.gw_BEL l3.gw_BEL l4.gw_BEL 
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7)  
   
test l1.cf1_BEL l2.cf1_BEL l3.cf1_BEL l4.cf1_BEL
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7) 
   
test l1.vu_BEL l2.vu_BEL l3.vu_BEL l4.vu_BEL
matrix b = r(p)'
putexcel D4 = matrix(b), nformat(number_d7)    

test l1.diffcpicf_BEL l2.diffcpicf_BEL l3.diffcpicf_BEL l4.diffcpicf_BEL
matrix b = r(p)'
putexcel D5 = matrix(b), nformat(number_d7)    

test l1.magpty_BEL
matrix b = r(p)'
putexcel D6 = matrix(b), nformat(number_d7)

test ussc1_BEL
matrix b = r(p)'
putexcel D7 = matrix(b), nformat(number_d7)


* R-square and number of observations
corr gw_BEL gwf1_social_BEL if period>=tq(1990:1)
gen r2aa_social_BEL = r(rho)^2
putexcel B9 = r2aa_social_BEL

gen n_obsaa_social_BEL = e(N)
putexcel B10 = n_obsaa_social_BEL

corr gw_BEL gwf1_social_BEL if period>=tq(1996:2) & period<=tq(2019:4)
di r(rho)^2

corr gw_BEL gwf1_social_BEL if period>=tq(1996:2) & period!=tq(2020:2) & period!=tq(2020:3) & period!=tq(2020:4) & period!=tq(2021:1) & period!=tq(2021:2) & period!=tq(2021:3) & period!=tq(2021:4)
di r(rho)^2


reg gw_BEL l1.gw_BEL l2.gw_BEL l3.gw_BEL l4.gw_BEL l1.cf1_BEL l2.cf1_BEL l3.cf1_BEL l4.cf1_BEL l1.magpty_BEL l1.vu_BEL l2.vu_BEL l3.vu_BEL l4.vu_BEL l1.diffcpicf_BEL l2.diffcpicf_BEL l3.diffcpicf_BEL l4.diffcpicf_BEL ussc1_BEL c.dQ1_BEL#cL.diffcpicf_BEL if inrange(period, tq(1996:1),tq(2019:4))

test _b[l1.gw_BEL] + _b[l2.gw_BEL] + _b[l3.gw_BEL] + _b[l4.gw_BEL] + _b[l1.cf1_BEL] + _b[l2.cf1_BEL] + _b[l3.cf1_BEL] + _b[l4.cf1_BEL] = 1
matrix b = r(p)'
putexcel B12 = matrix(b), nformat(number_d7)  


****************************************************************************************
* wage, full sample 
****************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"

*** USA ECB BOE FRA GER ESP CAN // ESP ITA NLD BEL don't use dummies 

local teams "USA ECB BOE FRA GER CAN"
local startperiod_USA 1989:1
local startperiod_ECB 1999:1
local startperiod_BOE 1990:1
local startperiod_FRA 1989:1
local startperiod_GER 1996:1
local startperiod_CAN 1993:1

foreach c of local teams{

constraint define 1  l1.gw_`c' + l2.gw_`c' + l3.gw_`c' + l4.gw_`c' + l1.cf1_`c' + l2.cf1_`c' + l3.cf1_`c' + l4.cf1_`c' = 1

cnsreg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' l1.magpty_`c' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' dummyq2_2020 dummyq3_2020 if inrange(period, tq(`startperiod_`c''),tq(2023:2)), c(1)

eststo col1
predict gwf1_`c'_full if inrange(period, tq(`startperiod_`c''),tq(2023:2))
gen gw_`c'_residuals_full = gw_`c'-gwf1_`c'_full

* Save coefficients in excel format 
putexcel set "(1) wage_eq_coeff", modify sheet("gw_`c'")
putexcel D1 = "beta_full"
putexcel D1 = "beta_full"
matrix b = e(b)'
putexcel C2 = matrix(b), rownames nformat(number_d7)

* P-value (sum)
putexcel set "(1) wage_summary_stats", modify sheet("gw_`c'")
putexcel G1 = "sum of coefficients_full"
putexcel G1 = "sum of coefficients_full"
putexcel H1 = "p value (sum)_full"
putexcel I1 = "p value (joint)_full"
putexcel F2 = "l1.gw through l4.gw"
putexcel F3 = "l1.cf1 through l4.cf1"
putexcel F4 = "l1.vu through l4.vu"
putexcel F5 = "l1.diffcpicf through l4.diffcpicf"
putexcel F6 = "magpty"
putexcel F7 = "dummy 2020Q2"
putexcel F8 = "dummy 2020Q3"
putexcel F10 = "R2"
putexcel F11 = "number of observations"
putexcel F13 = "homogeneity constraint"


* Compute sum of coefficients 
gen aa1_`c' = _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c']  
gen bb1_`c' = _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c']
gen cc1_`c' = _b[l1.vu_`c'] + _b[l2.vu_`c'] + _b[l3.vu_`c'] + _b[l4.vu_`c']  
gen dd1_`c' = _b[l1.diffcpicf_`c'] + _b[l2.diffcpicf_`c'] + _b[l3.diffcpicf_`c'] + _b[l4.diffcpicf_`c']

putexcel G2 = aa1_`c'
putexcel G3 = bb1_`c'
putexcel G4 = cc1_`c'
putexcel G5 = dd1_`c'

putexcel G6 = _b[l1.magpty_`c']

putexcel G7 = _b[dummyq2_2020]
putexcel G8 = _b[dummyq3_2020]


* P-value (sum)
test _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c']  = 0
matrix b = r(p)'
putexcel H2 = matrix(b), nformat(number_d7)                                          

test _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] = 0
matrix b = r(p)'
putexcel H3 = matrix(b), nformat(number_d7)

test _b[l1.vu_`c'] + _b[l2.vu_`c'] + _b[l3.vu_`c'] + _b[l4.vu_`c'] = 0
matrix b = r(p)'
putexcel H4 = matrix(b), nformat(number_d7)  

test _b[l1.diffcpicf_`c'] + _b[l2.diffcpicf_`c'] + _b[l3.diffcpicf_`c'] + _b[l4.diffcpicf_`c'] = 0
matrix b = r(p)'
putexcel H5 = matrix(b), nformat(number_d7) 

		   					   
* P-value (joint)
test l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' 
matrix b = r(p)'
putexcel I2 = matrix(b), nformat(number_d7)  
   
test l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c'
matrix b = r(p)'
putexcel I3 = matrix(b), nformat(number_d7) 
   
test l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c'
matrix b = r(p)'
putexcel I4 = matrix(b), nformat(number_d7)    

test l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c'
matrix b = r(p)'
putexcel I5 = matrix(b), nformat(number_d7)    

test l1.magpty_`c'
matrix b = r(p)'
putexcel I6 = matrix(b), nformat(number_d7)

test dummyq2_2020
matrix b = r(p)'
putexcel I7 = matrix(b), nformat(number_d7)

test dummyq3_2020
matrix b = r(p)'
putexcel I8 = matrix(b), nformat(number_d7)


* R-square and number of observations
corr gw_`c' gwf1_`c' if period>=tq(1990:1)
gen r2aa_`c' = r(rho)^2
putexcel G10 = r2aa_`c'

gen n_obsaa_`c' = e(N)
putexcel G11 = n_obsaa_`c'


*** unconstrained with homogeneity test 
reg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' l1.magpty_`c' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' dummyq2_2020 dummyq3_2020 if inrange(period, tq(`startperiod_`c''),tq(2023:2))

test _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c'] + _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] = 1
matrix b = r(p)'
putexcel G13 = matrix(b), nformat(number_d7)  

}


******** ESP ITA NLD 
* ESP adjust wage series; no dummies
* ITA use magpty instead of l1.magpty; no dummies
* NLD adjust wage growth; no dummies

local teams "ESP ITA NLD" 
local startperiod_ESP 1995:1
local startperiod_ITA 1999:1
local startperiod_NLD 1989:1

local m_ESP l1.magpty_ESP
local m_ITA magpty_ITA
local m_NLD l1.magpty_NLD
 

foreach c of local teams{

constraint define 1  l1.gw_`c' + l2.gw_`c' + l3.gw_`c' + l4.gw_`c' + l1.cf1_`c' + l2.cf1_`c' + l3.cf1_`c' + l4.cf1_`c' = 1

cnsreg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' `m_`c'' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' if inrange(period, tq(`startperiod_`c''),tq(2023:2)), c(1)

eststo col1
predict gwf1_`c'_full if inrange(period, tq(`startperiod_`c''),tq(2023:2))
gen gw_`c'_residuals_full = gw_`c'-gwf1_`c'_full

* Save coefficients in excel format 
putexcel set "(1) wage_eq_coeff", modify sheet("gw_`c'")
putexcel D1 = "beta_full"
putexcel D1 = "beta_full"
matrix b = e(b)'
putexcel C2 = matrix(b), rownames nformat(number_d7)

* P-value (sum)
putexcel set "(1) wage_summary_stats", modify sheet("gw_`c'")
putexcel G1 = "sum of coefficients_full"
putexcel G1 = "sum of coefficients_full"
putexcel H1 = "p value (sum)_full"
putexcel I1 = "p value (joint)_full"
putexcel F2 = "l1.gw through l4.gw"
putexcel F3 = "l1.cf1 through l4.cf1"
putexcel F4 = "l1.vu through l4.vu"
putexcel F5 = "l1.diffcpicf through l4.diffcpicf"
putexcel F6 = "magpty"
putexcel F7 = "dummy 2020Q2"
putexcel F8 = "dummy 2020Q3"
putexcel F10 = "R2"
putexcel F11 = "number of observations"
putexcel F13 = "homogeneity constraint"


* Compute sum of coefficients 
gen aa1_`c' = _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c']  
gen bb1_`c' = _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c']
gen cc1_`c' = _b[l1.vu_`c'] + _b[l2.vu_`c'] + _b[l3.vu_`c'] + _b[l4.vu_`c']  
gen dd1_`c' = _b[l1.diffcpicf_`c'] + _b[l2.diffcpicf_`c'] + _b[l3.diffcpicf_`c'] + _b[l4.diffcpicf_`c']

putexcel G2 = aa1_`c'
putexcel G3 = bb1_`c'
putexcel G4 = cc1_`c'
putexcel G5 = dd1_`c'

putexcel G6 = _b[`m_`c'']

*putexcel G7 = _b[dummyq2_2020]
*putexcel G8 = _b[dummyq3_2020]


* P-value (sum)
test _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c']  = 0
matrix b = r(p)'
putexcel H2 = matrix(b), nformat(number_d7)                                          

test _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] = 0
matrix b = r(p)'
putexcel H3 = matrix(b), nformat(number_d7)

test _b[l1.vu_`c'] + _b[l2.vu_`c'] + _b[l3.vu_`c'] + _b[l4.vu_`c'] = 0
matrix b = r(p)'
putexcel H4 = matrix(b), nformat(number_d7)  

test _b[l1.diffcpicf_`c'] + _b[l2.diffcpicf_`c'] + _b[l3.diffcpicf_`c'] + _b[l4.diffcpicf_`c'] = 0
matrix b = r(p)'
putexcel H5 = matrix(b), nformat(number_d7) 

		   					   
* P-value (joint)
test l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' 
matrix b = r(p)'
putexcel I2 = matrix(b), nformat(number_d7)  
   
test l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c'
matrix b = r(p)'
putexcel I3 = matrix(b), nformat(number_d7) 
   
test l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c'
matrix b = r(p)'
putexcel I4 = matrix(b), nformat(number_d7)    

test l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c'
matrix b = r(p)'
putexcel I5 = matrix(b), nformat(number_d7)    

test `m_`c''
matrix b = r(p)'
putexcel I6 = matrix(b), nformat(number_d7)

*test dummyq2_2020
*matrix b = r(p)'
*putexcel I7 = matrix(b), nformat(number_d7)

*test dummyq3_2020
*matrix b = r(p)'
*putexcel I8 = matrix(b), nformat(number_d7)


* R-square and number of observations
corr gw_`c' gwf1_`c' if period>=tq(1990:1)
gen r2aa_`c' = r(rho)^2
putexcel G10 = r2aa_`c'

gen n_obsaa_`c' = e(N)
putexcel G11 = n_obsaa_`c'


*** unconstrained with homogeneity test 
reg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' `m_`c'' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' if inrange(period, tq(`startperiod_`c''),tq(2023:2))

test _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c'] + _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] = 1
matrix b = r(p)'
putexcel G13 = matrix(b), nformat(number_d7)  


}

******** Belgium with social programs variable ssci *******
constraint define 1 l1.gw_BEL + l2.gw_BEL + l3.gw_BEL + l4.gw_BEL + l1.cf1_BEL + l2.cf1_BEL + l3.cf1_BEL + l4.cf1_BEL = 1

cnsreg gw_BEL l1.gw_BEL l2.gw_BEL l3.gw_BEL l4.gw_BEL l1.cf1_BEL l2.cf1_BEL l3.cf1_BEL l4.cf1_BEL l1.magpty_BEL l1.vu_BEL l2.vu_BEL l3.vu_BEL l4.vu_BEL l1.diffcpicf_BEL l2.diffcpicf_BEL l3.diffcpicf_BEL l4.diffcpicf_BEL ussc1_BEL c.dQ1_BEL#cL.diffcpicf_BEL if inrange(period, tq(1996:1),tq(2023:2)), c(1)

eststo col1
predict gwf1_social_BEL if inrange(period, tq(1996:1),tq(2023:2))
gen gw_social_residuals_BEL = gw_BEL-gwf1_social_BEL


* Save coefficients in excel format 
putexcel set "(1) wage_eq_coeff", modify sheet("gw_social_BEL")
putexcel D1 = "beta_full"
putexcel D1 = "beta_full"
matrix b = e(b)'
putexcel C2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(1) wage_summary_stats", modify sheet("gw_social_BEL")
putexcel G1 = "sum of coefficients_full"
putexcel G1 = "sum of coefficients_full"
putexcel H1 = "p value (sum)_full"
putexcel I1 = "p value (joint)_full"
putexcel I2 = "l1.gw_social through l4.gw_social"
putexcel F3 = "l1.cf1 through l4.cf1"
putexcel F4 = "l1.vu through l4.vu"
putexcel F5 = "l1.diffcpicf through l4.diffcpicf"
putexcel F6 = "magpty"
putexcel F7 = "social programs"
putexcel F9 = "R2"
putexcel F10 = "number of observations"
putexcel F12 = "homogeneity constraint"


* Compute sum of coefficients 
gen aa1_social_BEL = _b[l1.gw_BEL] + _b[l2.gw_BEL] + _b[l3.gw_BEL] + _b[l4.gw_BEL]  
gen bb1_social_BEL = _b[l1.cf1_BEL] + _b[l2.cf1_BEL] + _b[l3.cf1_BEL] + _b[l4.cf1_BEL]
gen cc1_social_BEL = _b[l1.vu_BEL] + _b[l2.vu_BEL] + _b[l3.vu_BEL] + _b[l4.vu_BEL]  
gen dd1_social_BEL = _b[l1.diffcpicf_BEL] + _b[l2.diffcpicf_BEL] + _b[l3.diffcpicf_BEL] + _b[l4.diffcpicf_BEL]

putexcel G2 = aa1_social_BEL
putexcel G3 = bb1_social_BEL
putexcel G4 = cc1_social_BEL
putexcel G5 = dd1_social_BEL

putexcel G6 = _b[l1.magpty_BEL]
putexcel G7 = _b[ussc1_BEL]


* P-value (sum)
test _b[l1.gw_BEL] + _b[l2.gw_BEL] + _b[l3.gw_BEL] + _b[l4.gw_BEL]  = 0
matrix b = r(p)'
putexcel H2 = matrix(b), nformat(number_d7)                                          

test _b[l1.cf1_BEL] + _b[l2.cf1_BEL] + _b[l3.cf1_BEL] + _b[l4.cf1_BEL] = 0
matrix b = r(p)'
putexcel H3 = matrix(b), nformat(number_d7)

test _b[l1.vu_BEL] + _b[l2.vu_BEL] + _b[l3.vu_BEL] + _b[l4.vu_BEL] = 0
matrix b = r(p)'
putexcel H4 = matrix(b), nformat(number_d7)  

test _b[l1.diffcpicf_BEL] + _b[l2.diffcpicf_BEL] + _b[l3.diffcpicf_BEL] + _b[l4.diffcpicf_BEL] = 0
matrix b = r(p)'
putexcel H5 = matrix(b), nformat(number_d7) 

 				   					   
* P-value(joint)
test l1.gw_BEL l2.gw_BEL l3.gw_BEL l4.gw_BEL 
matrix b = r(p)'
putexcel I2 = matrix(b), nformat(number_d7)  
   
test l1.cf1_BEL l2.cf1_BEL l3.cf1_BEL l4.cf1_BEL
matrix b = r(p)'
putexcel I3 = matrix(b), nformat(number_d7) 
   
test l1.vu_BEL l2.vu_BEL l3.vu_BEL l4.vu_BEL
matrix b = r(p)'
putexcel I4 = matrix(b), nformat(number_d7)    

test l1.diffcpicf_BEL l2.diffcpicf_BEL l3.diffcpicf_BEL l4.diffcpicf_BEL
matrix b = r(p)'
putexcel I5 = matrix(b), nformat(number_d7)    

test l1.magpty_BEL
matrix b = r(p)'
putexcel I6 = matrix(b), nformat(number_d7)

test ussc1_BEL
matrix b = r(p)'
putexcel I7 = matrix(b), nformat(number_d7)


* R-square and number of observations
corr gw_BEL gwf1_social_BEL if period>=tq(1990:1)
gen r2aa_social_BEL = r(rho)^2
putexcel G9 = r2aa_social_BEL

gen n_obsaa_social_BEL = e(N)
putexcel G10 = n_obsaa_social_BEL

corr gw_BEL gwf1_social_BEL if period>=tq(1996:2) & period<=tq(2019:4)
di r(rho)^2

corr gw_BEL gwf1_social_BEL if period>=tq(1996:2) & period!=tq(2020:2) & period!=tq(2020:3) & period!=tq(2020:4) & period!=tq(2021:1) & period!=tq(2021:2) & period!=tq(2021:3) & period!=tq(2021:4)
di r(rho)^2


*** unconstrained with homogeneity test 
reg gw_BEL l1.gw_BEL l2.gw_BEL l3.gw_BEL l4.gw_BEL l1.cf1_BEL l2.cf1_BEL l3.cf1_BEL l4.cf1_BEL l1.magpty_BEL l1.vu_BEL l2.vu_BEL l3.vu_BEL l4.vu_BEL l1.diffcpicf_BEL l2.diffcpicf_BEL l3.diffcpicf_BEL l4.diffcpicf_BEL ussc1_BEL c.dQ1_BEL#cL.diffcpicf_BEL if inrange(period, tq(1996:1),tq(2023:2))

test _b[l1.gw_BEL] + _b[l2.gw_BEL] + _b[l3.gw_BEL] + _b[l4.gw_BEL] + _b[l1.cf1_BEL] + _b[l2.cf1_BEL] + _b[l3.cf1_BEL] + _b[l4.cf1_BEL] = 1
matrix b = r(p)'
putexcel G12 = matrix(b), nformat(number_d7)  
